		function alfa = CT_TREE_WDF_LP(P)
		
		% 	Computes the adaptor coefficients in an odd order lowpass
		%	circulator-tree wave digital filter consisting of 
		%	three- and four-port adaptors. The first coefficient
		%	is the first-order section.    
		
		%	Toolbox for DIGITAL FILTERS USING MATLAB
		
		% 	Author: 			Lars Wanhammar 2009-11-15
		% 	Modified by: 	 	Lw 2011-07-04, 2014-08-23
		% 	Copyright:			by authors - not released for commercial use
		% 	Version:			1 
		% 	Known bugs:		
		% 	Report bugs to:		Wanhammar@gmail.com
		
		P = flipud(cplxpair(P));
		if mod(length(P),2) == 0
			error('Must be an odd order filter')
		end
		if real(P) == 0
			Ps = sort(P);	% Bireciprocal case
		else
			Ps = sort([P, angle(P)], 1);
		end
		P(3:2:end,:) = [];	% remove complex conjugat poles
		N = length(P);
		alfa = zeros(N,4);
		for k = 2:N				% Compute the adaptor coefficients
			alfa(k,1) = (1 - abs(P(k))^2)/2;
			alfa(k,2) = alfa(k,1);						% alfa2 = alfa1
			alfa(k,3) = 1 - alfa(k,1) - real(P(k));		% alfa3
			alfa(k,4) = 2 - 2*alfa(k,1)-alfa(k,3);		 % alfa4 
		end
		alfa(1,1) = (1 - P(1))/2;	
		alfa(1,2) = alfa(1,1);	
		alfa(1,3) = 2 - 2*alfa(1,1);	
		alfa(1,4) = 1;	% Set to 1 to avoide calling mincost(0
		
		
		
